# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR9(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Rounds 2-3: Continue cooperating to encourage mutual cooperation
    elif current_round <= 3:
        return "C"
    
    # Rounds 4-7: Defect if opponent cooperated in Rounds 2-3, else mirror their last move
    elif current_round <= 7:
        if len(opp_history) >= 2 and opp_history[1] == "C" and opp_history[2] == "C":
            return "D"
        else:
            return opp_history[-1] if opp_history else "C"
    
    # Rounds 8-10: Defect if opponent ever defected, else continue defecting
    else:
        if "D" in opp_history:
            return "D"
        else:
            return "D"